﻿<# AP機器読取ツール PowerShell版 2023/11/06
●説明
・メインスクリプトです。通常はこのスクリプトにてツールを起動します。
・スクリプトを編集およびデバッグするには、実行ポリシーの設定を変更する必要があります。管理者権限でPowerShellを起動し、下記コマンドレットを実行してください。
    Set-ExecutionPolicy RemoteSigned
・読取データは、指定したファイル名にてテキスト形式で出力されます。データはファイルへ常に追記されていきますので、過去の不要データは都度削除をしてください。

●サブスクリプト
以下のファイルは本スクリプトが起動時に読み込む必要があるため、同一フォルダ内に入れてください。
・SerialComm.ps1　 シリアル通信
・ReadExte.ps1　読取拡張機能

●注意事項
・本スクリプトを終了するには実行時に作成される"ApTool_実行中.txt"ファイルを削除します。
・例外処理について、最低限の処理にとどめておりエラーの発生時には強制終了します。必要に応じて処理を追加してください。
#>
################################################## パラメータ
$ReadData_Path = ".\ReadData.txt"  #読取データ出力ファイルパス
$WinTitle = "ApTool"  #ダイアログ タイトル

$PrintOk = ""    #読取OK時の印字文字 ※対応していない機器は設定しないでください。
$PrintNg = ""    #読取NG時の印字文字 ※対応していない機器は設定しないでください。
                 #レフトマージン指定:"[ESC]l0"  拡大文字指定:"[SO]" 拡大文字解除:"[SI]"  例）"[ESC]l2[SO]abc[SI]def"  #レフトマージンを2、拡大文字abc、通常文字def
                 #読取OK/NG枚数:"[Count]" 現在日付:"[DateNow]" 現在時間:"[TimeNow]"

################################################## イニシャル処理
#---+---+---+---+---+---+---+---+---+---+ アセンブリのロード
Add-Type -AssemblyName System.Windows.Forms
add-type -AssemblyName microsoft.VisualBasic

#---+---+---+---+---+---+---+---+---+---+ オブジェクト生成
$oWS = New-Object -ComObject Wscript.Shell  #COMオブジェクト（ダイアログ表示用）

#---+---+---+---+---+---+---+---+---+---+ スクリプト動作
$ErrorActionPreference = "stop"    #エラー発生時にはスクリプトを中断します。

################################################## スクリプト ファイル読み込み
. ".\SerialComm.ps1"   #シリアル通信
. ".\ReadExte.ps1"     #読取拡張機能

################################################## ファイル作成
If (-not (Test-Path $ReadData_Path)) { New-Item $ReadData_Path }    #読取データファイル作成。ファイルがなければ新規作成

################################################## 読取OK／エラー処理
#---+---+---+---+---+---+---+---+---+---+ 読取OK/NG枚数 初期値セット
If (Test-Path $ReadData_Path) {
    $ReadOk_Cnt = (Get-Content $ReadData_Path).Length    #読み取りOK枚数 ファイル行数を枚数として設定
} Else {
    $ReadOk_Cnt = 0  #読み取りOK枚数
}
$ReadNg_Cnt = 0  #読み取りNG枚数

#---+---+---+---+---+---+---+---+---+---+ 読取OK
Function ReadOkSub($ReadStr) {
    $ReadStr = ReadExteSub $ReadStr  #読取拡張機能
    If ($ReadStr -ne "") {  #正常
        $Script:ReadOk_Cnt++  #読取OK枚数カウント
        Write-Host (("{0:D4}" -f $ReadOk_Cnt) + ":" + $ReadStr)  #読取データをコンソール表示 枚数を4桁で0パディング
        Write-Output $ReadStr | Out-File -FilePath $ReadData_Path -Encoding Default -Append  #読取データをファイルへ追記

        #正常排出コマンド送信
        SendSub (PrintConvSub $CommP0 $PrintOk $ReadOk_Cnt)  #印字データ変換送信
    }
}

#---+---+---+---+---+---+---+---+---+---+ 読取エラー
Function ReadNgSub() {
    $Script:ReadNg_Cnt++  #読取NG枚数カウント
    Write-Host (("{0:D4}" -f $ReadNg_Cnt) + ":ReadError") -ForegroundColor Magenta  #読取エラーをコンソール表示 枚数を4桁で0パディング

    #エラー排出コマンド
    SendSub (PrintConvSub $CommP1 $PrintNg $ReadNg_Cnt)  #印字データ変換送信
}

#---+---+---+---+---+---+---+---+---+---+ 印字データ変換処理
#戻り値：変換後の印字データ
Function PrintConvSub($Comm, $PrintStr, $Cnt) {
    If ($PrintStr -ne "") {
        If ($Comm -match "`r$") { $Comm = $Comm.Substring(0, $Comm.Length - 1) }  #末尾CRがあれば削除
        $PrintStr = $PrintStr.Replace("[ESC]", $([char]0x1b))  #ESCコード
        $PrintStr = $PrintStr.Replace("[SO]", $([char]0x0e))  #SOコード
        $PrintStr = $PrintStr.Replace("[SI]", $([char]0x0f))  #SIコード
        $PrintStr = $PrintStr.Replace("[Count]", ("{0:D4}" -f $Cnt))  #読取OK/NG枚数 枚数を4桁で0パディング
        $PrintStr = $PrintStr.Replace("[DateNow]", (Get-Date -Format "d"))  #読取OKカウント
        $PrintStr = $PrintStr.Replace("[TimeNow]", (Get-Date -Format "t"))  #読取OKカウント
        Return ($Comm + $PrintStr + "`r")
    }
    Return $Comm
}

################################################## メイン シリアル通信処理
Try {
    #---+---+---+---+---+---+---+---+---+---+ 起動時コマンド送信
    If (Test-Path $Active_FileName) { StartSub }
    #---+---+---+---+---+---+---+---+---+---+ メインループ
    While (Test-Path $Active_FileName) {    #実行中ファイルが存在する間ループ
        MainSub
    }
} Catch {
    $error[0] | Out-string | write-host -ForegroundColor red  #エラー表示
} finally {
    ComCloseSub  #COMポートクローズ
}
################################################## 終了処理
#[void]$oWS.Popup("読取を終了します。", 0, $WinTitle, 0)
[void][System.Runtime.Interopservices.Marshal]::ReleaseComObject($oWS)  #COMオブジェクト解放
Exit  #スクリプト終了
